/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search.uhighlight;

import guideme.internal.shaded.lucene.index.FilterLeafReader;
import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.index.LeafReader;
import guideme.internal.shaded.lucene.index.PostingsEnum;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.automaton.CompiledAutomaton;
import java.io.IOException;

public class OverlaySingleDocTermsLeafReader
extends FilterLeafReader {
    private final LeafReader in2;
    private final String in2Field;
    private final int in2TargetDocId;

    public OverlaySingleDocTermsLeafReader(LeafReader in, LeafReader in2, String in2Field, int in2TargetDocId) {
        super(in);
        this.in2 = in2;
        this.in2Field = in2Field;
        this.in2TargetDocId = in2TargetDocId;
        assert (in2.maxDoc() == 1);
    }

    @Override
    public Terms terms(String field) throws IOException {
        if (!this.in2Field.equals(field)) {
            return this.in.terms(field);
        }
        Terms terms = this.in2.terms(field);
        if (terms == null) {
            return null;
        }
        if (this.in2TargetDocId == 0) {
            return terms;
        }
        return new FilterLeafReader.FilterTerms(terms){

            @Override
            public TermsEnum iterator() throws IOException {
                return this.filterTermsEnum(super.iterator());
            }

            @Override
            public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
                return this.filterTermsEnum(super.intersect(compiled, startTerm));
            }

            private TermsEnum filterTermsEnum(TermsEnum termsEnum) throws IOException {
                return new FilterLeafReader.FilterTermsEnum(termsEnum){

                    @Override
                    public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
                        return new FilterLeafReader.FilterPostingsEnum(super.postings(reuse, flags)){

                            @Override
                            public int nextDoc() throws IOException {
                                int doc = super.nextDoc();
                                return doc == 0 ? OverlaySingleDocTermsLeafReader.this.in2TargetDocId : doc;
                            }

                            @Override
                            public int advance(int target) throws IOException {
                                return this.slowAdvance(target);
                            }

                            @Override
                            public int docID() {
                                int doc = super.docID();
                                return doc == 0 ? OverlaySingleDocTermsLeafReader.this.in2TargetDocId : doc;
                            }
                        };
                    }
                };
            }
        };
    }

    @Override
    public IndexReader.CacheHelper getCoreCacheHelper() {
        return null;
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return null;
    }
}

